"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "buildVersionCompatibilityCheck", {
    enumerable: true,
    get: function() {
        return buildVersionCompatibilityCheck;
    }
});
const _semvercompare = /*#__PURE__*/ _interop_require_default(require("semver-compare"));
const _semverdiff = /*#__PURE__*/ _interop_require_default(require("semver-diff"));
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _constants = require("@tamanu/constants");
const _logging = require("../services/logging");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const respondWithError = (res, error)=>{
    res.status(400).json({
        error
    });
};
function getUpdateInformation(req, minVersion) {
    if (!_config.default.updateUrls) return {};
    const clientType = req.header('X-Tamanu-Client') || '';
    if (clientType.includes('Tamanu Mobile')) {
        return {
            updateUrl: _config.default.updateUrls.mobile.replaceAll('{minVersion}', minVersion)
        };
    }
    return {};
}
const buildVersionCompatibilityCheck = (min, max)=>(req, res, next)=>{
        // include the min/max supported clients with any response
        if (min) {
            res.setHeader('X-Min-Client-Version', min);
        }
        if (max) {
            res.setHeader('X-Max-Client-Version', max);
        }
        // check the connecting client is supported, and respond with an error if not
        const clientVersion = req.header('X-Version');
        if (!clientVersion) {
            // a thirdparty tool (or internal test suite) is using the API; ignore version checking
            next();
            return;
        }
        if (min && (0, _semvercompare.default)(clientVersion, min) < 0) {
            respondWithError(res, {
                message: _constants.VERSION_COMPATIBILITY_ERRORS.LOW,
                name: 'InvalidClientVersion',
                ...getUpdateInformation(req, min)
            });
            return;
        }
        if (max && (0, _semvercompare.default)(clientVersion, max) > 0) {
            if ((0, _semverdiff.default)(max, clientVersion) === 'patch') {
                _logging.log.error(`Allowing client v${clientVersion} with higher patch than max supported v${max} to connect`);
                next();
                return;
            }
            respondWithError(res, {
                message: _constants.VERSION_COMPATIBILITY_ERRORS.HIGH,
                name: 'InvalidClientVersion'
            });
            return;
        }
        next();
    };

//# sourceMappingURL=buildVersionCompatibilityCheck.js.map