"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    Text: function() {
        return Text;
    },
    TextWithoutContext: function() {
        return TextWithoutContext;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _languageContext = require("./languageContext");
const _flattenStyles = require("./flattenStyles");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const TextWithoutContext = ({ style, bold, makeIntlStyleSheet, pdfFontBold, pdfFont, ...props })=>{
    const mergedStyle = (0, _flattenStyles.flatten)(style);
    const newStyles = makeIntlStyleSheet({
        ...mergedStyle,
        ...bold ? {
            fontFamily: pdfFontBold,
            fontWeight: 700
        } : {
            fontFamily: pdfFont
        }
    }, bold);
    return /*#__PURE__*/ _react.default.createElement(_renderer.Text, {
        style: newStyles,
        ...props
    });
};
const Text = (props)=>{
    const { makeIntlStyleSheet, pdfFont, pdfFontBold } = (0, _languageContext.useLanguageContext)();
    return /*#__PURE__*/ _react.default.createElement(TextWithoutContext, {
        makeIntlStyleSheet: makeIntlStyleSheet,
        pdfFont: pdfFont,
        pdfFontBold: pdfFontBold,
        ...props
    });
};

//# sourceMappingURL=Text.js.map