"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "generateUVCI", {
    enumerable: true,
    get: function() {
        return generateUVCI;
    }
});
const _tamanu = require("./tamanu");
const _eudcc = require("./eudcc");
const _icao = require("./icao");
function generateUVCI(vaccinationId, { format, countryCode }) {
    switch(format){
        case 'tamanu':
            {
                return (0, _tamanu.generateDefaultFormatUVCI)(vaccinationId, countryCode);
            }
        case 'icao':
            {
                return (0, _icao.generateICAOFormatUVCI)(vaccinationId);
            }
        case 'eudcc':
            {
                return (0, _eudcc.generateEUDCCFormatUVCI)(vaccinationId, countryCode);
            }
        default:
            {
                throw new Error(`Unrecognised UVCI format: ${format}`);
            }
    }
}

//# sourceMappingURL=generateUVCI.js.map