"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    buildEncounterLinkedSyncFilter: function() {
        return buildEncounterLinkedSyncFilter;
    },
    buildEncounterLinkedSyncFilterJoins: function() {
        return buildEncounterLinkedSyncFilterJoins;
    }
});
const _sequelize = require("sequelize");
const _lodash = require("lodash");
function buildEncounterLinkedSyncFilterJoins(tablesToTraverse) {
    return tablesToTraverse.slice(1).map((table, i)=>{
        const currentTable = (0, _lodash.isString)(tablesToTraverse[i]) ? tablesToTraverse[i] : tablesToTraverse[i]?.model.tableName;
        const joinTable = (0, _lodash.isString)(table) ? table : table.model.tableName;
        const joinColumn = (0, _lodash.isString)(table) ? `${_sequelize.Utils.singularize(table)}_id` : table.joinColumn;
        const joinType = (0, _lodash.isObject)(table) && table.required ? 'INNER' : 'LEFT';
        return `
        ${joinType} JOIN ${joinTable} ON ${currentTable}.${joinColumn} = ${joinTable}.id
      `;
    }).join('\n');
}
function buildEncounterLinkedSyncFilter(tablesToTraverse, markedForSyncPatientsTable) {
    const joins = buildEncounterLinkedSyncFilterJoins(tablesToTraverse);
    return `
    ${joins}
    WHERE encounters.patient_id IN (SELECT patient_id FROM ${markedForSyncPatientsTable})
    AND ${tablesToTraverse[0]}.updated_at_sync_tick > :since
  `;
}

//# sourceMappingURL=buildEncounterLinkedSyncFilter.js.map