import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
import { buildEncounterPatientIdSelect, buildEncounterLinkedSyncFilter, buildEncounterLinkedSyncFilterJoins } from '../sync';
export class PharmacyOrderPrescription extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            quantity: {
                type: DataTypes.INTEGER,
                allowNull: false
            },
            repeats: {
                type: DataTypes.INTEGER,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.PharmacyOrder, {
            foreignKey: 'pharmacyOrderId',
            as: 'pharmacyOrder'
        });
        this.belongsTo(models.Prescription, {
            foreignKey: 'prescriptionId',
            as: 'prescription'
        });
    }
    static getListReferenceAssociations() {
        return [
            'pharmacyOrder',
            'prescription'
        ];
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return buildEncounterLinkedSyncFilter([
            this.tableName,
            'pharmacy_orders',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: buildEncounterPatientIdSelect(this),
            joins: buildEncounterLinkedSyncFilterJoins([
                this.tableName,
                'pharmacy_orders',
                'encounters'
            ])
        };
    }
}

//# sourceMappingURL=PharmacyOrderPrescription.js.map