export declare const pem: (data: Buffer, banner: string) => string;
/**
 * Decode a PEM document to a Buffer of DER data.
 */
export declare const depem: (pemString: string, expectedBanner: string) => Buffer<ArrayBuffer>;
/**
 * Encode the input to Base64, the URL variant.
 */
export declare const base64UrlEncode: (input: string | Buffer | ArrayBuffer) => string;
/**
 * Decode the input string from Base64, the URL variant.
 */
export declare const base64UrlDecode: (input: string) => Buffer<ArrayBuffer>;
/**
 * Encodes Base64 string string to JSON.
 */
export declare const base64ToJson: <T = unknown>(base64str: string) => T;
/**
 * Creates a JSON object with the input and converts it to a Base64 string.
 */
export declare const jsonToBase64: (obj: Record<string, unknown>) => string;
//# sourceMappingURL=encodings.d.ts.map