"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "reportRequest", {
    enumerable: true,
    get: function() {
        return reportRequest;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _constants = require("@tamanu/constants");
const _reports = require("@tamanu/shared/reports");
const _createNamedLogger = require("@tamanu/shared/services/logging/createNamedLogger");
const _checkReportModulePermissions = require("@tamanu/shared/reports/utilities/checkReportModulePermissions");
const _errors = require("@tamanu/shared/errors");
const _assertReportEnabled = require("../../utils/assertReportEnabled");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const reportRequest = _express.default.Router();
const REPORT_REQUEST_LOG_NAME = 'ReportRequest';
reportRequest.post('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, body, user, getLocalisation } = req;
    const { ReportRequest, ReportDefinitionVersion } = models;
    const { reportId } = body;
    const reportRequestLog = (0, _createNamedLogger.createNamedLogger)(REPORT_REQUEST_LOG_NAME, {
        reportId,
        userId: user.id
    });
    if (!reportId) {
        throw new _errors.NotFoundError('Report id not specified');
    }
    const localisation = await getLocalisation();
    (0, _assertReportEnabled.assertReportEnabled)(localisation, reportId);
    const reportModule = await (0, _reports.getReportModule)(reportId, models);
    if (!reportModule) {
        throw new _errors.NotFoundError('Report module not found');
    }
    await (0, _checkReportModulePermissions.checkReportModulePermissions)(req, reportModule, reportId, body.parameters);
    const isDatabaseDefinedReport = reportModule instanceof ReportDefinitionVersion;
    const newReportRequest = {
        ...isDatabaseDefinedReport ? {
            reportDefinitionVersionId: reportId
        } : {
            reportType: reportId
        },
        recipients: JSON.stringify({
            email: body.emailList
        }),
        status: _constants.REPORT_REQUEST_STATUSES.RECEIVED,
        requestedByUserId: user.id,
        parameters: JSON.stringify(body.parameters),
        exportFormat: body.bookType
    };
    try {
        reportRequestLog.info('Report request creating', {
            recipients: newReportRequest.recipients,
            parameters: newReportRequest.parameters
        });
        const createdRequest = await ReportRequest.create(newReportRequest);
        reportRequestLog.info('Report request created', {
            recipients: newReportRequest.recipients,
            parameters: newReportRequest.parameters
        });
        res.send(createdRequest);
    } catch (e) {
        reportRequestLog.error('Report request failed to create', {
            stack: e.stack
        });
        res.status(400).send({
            error: {
                message: e.message
            }
        });
    }
}));

//# sourceMappingURL=reportRequest.js.map