"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    hl7ParameterTypes: function() {
        return hl7ParameterTypes;
    },
    modifiers: function() {
        return modifiers;
    },
    stringTypeModifiers: function() {
        return stringTypeModifiers;
    }
});
const _sequelize = require("sequelize");
const hl7ParameterTypes = {
    number: 'number',
    date: 'date',
    string: 'string',
    token: 'token',
    reference: 'reference',
    composite: 'composite',
    quantity: 'quantity',
    uri: 'uri',
    special: 'special'
};
const modifiers = {
    [hl7ParameterTypes.string]: {
        contains: _sequelize.Op.substring,
        'starts-with': _sequelize.Op.startsWith,
        'ends-with': _sequelize.Op.endsWith,
        exact: _sequelize.Op.eq
    }
};
const stringTypeModifiers = Object.keys(modifiers.string);

//# sourceMappingURL=hl7Parameters.js.map