"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "telegramWebhookRoutes", {
    enumerable: true,
    get: function() {
        return telegramWebhookRoutes;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _logging = require("@tamanu/shared/services/logging");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const telegramWebhookRoutes = _express.default.Router();
telegramWebhookRoutes.post(`/`, (0, _expressasynchandler.default)(async (req, res)=>{
    _logging.log.info('Received telegram webhook', req.body);
    if (req.header('X-Telegram-Bot-Api-Secret-Token') !== _config.default.telegramBot?.webhook.secret) return res.status(401).send('Invalid token');
    req.ctx.telegramBotService?.update(req.body);
    res.sendStatus(200);
}));

//# sourceMappingURL=telegramWebhook.js.map