"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    ADD_SENSITIVE_FACILITY_ID_IF_APPLICABLE: function() {
        return ADD_SENSITIVE_FACILITY_ID_IF_APPLICABLE;
    },
    buildEncounterLinkedLookupFilter: function() {
        return buildEncounterLinkedLookupFilter;
    },
    buildEncounterLinkedLookupJoins: function() {
        return buildEncounterLinkedLookupJoins;
    },
    buildEncounterLinkedLookupSelect: function() {
        return buildEncounterLinkedLookupSelect;
    }
});
const _buildEncounterLinkedSyncFilter = require("./buildEncounterLinkedSyncFilter");
const _buildSyncLookupSelect = require("./buildSyncLookupSelect");
const ADD_SENSITIVE_FACILITY_ID_IF_APPLICABLE = `
    CASE
      WHEN facilities.is_sensitive = TRUE THEN facilities.id
      ELSE NULL
    END
  `;
async function buildEncounterLinkedLookupSelect(model, extraSelects) {
    return await (0, _buildSyncLookupSelect.buildSyncLookupSelect)(model, {
        patientId: 'encounters.patient_id',
        facilityId: ADD_SENSITIVE_FACILITY_ID_IF_APPLICABLE,
        ...extraSelects
    });
}
function buildEncounterLinkedLookupJoins(model, joinsToEncounters) {
    return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilterJoins)([
        model.tableName,
        ...joinsToEncounters || [
            'encounters'
        ],
        'locations',
        'facilities'
    ]);
}
async function buildEncounterLinkedLookupFilter(model) {
    return {
        select: await buildEncounterLinkedLookupSelect(model),
        joins: buildEncounterLinkedLookupJoins(model)
    };
}

//# sourceMappingURL=buildEncounterLinkedLookupFilter.js.map