import Sequelize from 'sequelize';
export async function up(query) {
    await query.createTable('ips_requests', {
        id: {
            type: Sequelize.STRING,
            defaultValue: Sequelize.fn('uuid_generate_v4'),
            allowNull: false,
            primaryKey: true
        },
        created_at: {
            type: Sequelize.DATE,
            defaultValue: Sequelize.fn('current_timestamp', 3),
            allowNull: false
        },
        updated_at: {
            type: Sequelize.DATE,
            defaultValue: Sequelize.NOW,
            allowNull: false
        },
        deleted_at: {
            type: Sequelize.DATE,
            allowNull: true
        },
        patient_id: {
            type: Sequelize.STRING,
            allowNull: false,
            references: {
                model: 'patients',
                key: 'id'
            }
        },
        created_by: {
            type: Sequelize.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        status: {
            type: Sequelize.STRING,
            allowNull: false
        },
        email: {
            type: Sequelize.STRING,
            allowNull: false
        }
    });
}
export async function down(query) {
    await query.dropTable('ips_requests');
}

//# sourceMappingURL=1699831661035_addIPSRequestTable.js.map