import { QueryTypes } from 'sequelize';
import { runFunctionInBatches } from '@tamanu/utils/runFunctionInBatches';
export const attachChangelogToSnapshotRecords = async ({ models, sequelize }, snapshotRecords, { minSourceTick, maxSourceTick })=>{
    if (!snapshotRecords.length) {
        return snapshotRecords;
    }
    const changelogRecords = await runFunctionInBatches(snapshotRecords, async (snapshotRecordBatch)=>sequelize.query(`
          SELECT * FROM logs.changes
          WHERE updated_at_sync_tick >= ?
          ${maxSourceTick ? 'AND updated_at_sync_tick <= ?' : ''}
          AND (table_name, record_id) IN (VALUES ${snapshotRecordBatch.map(()=>`(?, ?)`).join(',')});
        `, {
            model: models.ChangeLog,
            type: QueryTypes.SELECT,
            mapToModel: true,
            replacements: [
                minSourceTick,
                ...maxSourceTick ? [
                    maxSourceTick
                ] : [],
                ...snapshotRecordBatch.map(({ recordType, recordId })=>[
                        recordType,
                        recordId
                    ]).flat()
            ]
        }));
    const changelogRecordsByRecordId = changelogRecords.reduce((acc, changelogRecord)=>{
        const id = `${changelogRecord.tableName}-${changelogRecord.recordId}`;
        (acc[id] = acc[id] || []).push(changelogRecord);
        return acc;
    }, {});
    snapshotRecords.forEach((snapshotRecord)=>{
        const id = `${snapshotRecord.recordType}-${snapshotRecord.recordId}`;
        snapshotRecord.changelogRecords = changelogRecordsByRecordId[id] || [];
    });
    return snapshotRecords;
};

//# sourceMappingURL=attachChangelogToSnapshotRecords.js.map