"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('encounters', 'planned_location_id', {
        type: _sequelize.STRING,
        allowNull: true,
        references: {
            model: 'locations',
            key: 'id'
        }
    });
    await query.addColumn('encounters', 'planned_location_start_time', {
        type: 'date_time_string',
        allowNull: true
    });
}
async function down(query) {
    await query.removeColumn('encounters', 'planned_location_id');
    await query.removeColumn('encounters', 'planned_location_start_time');
}

//# sourceMappingURL=120_encountersAddPlannedLocation.js.map