"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('facilities', 'catchment_id', {
        type: _sequelize.DataTypes.TEXT,
        references: {
            model: 'reference_data',
            key: 'id'
        },
        allowNull: true
    });
    await query.addIndex('facilities', [
        'catchment_id'
    ]);
}
async function down(query) {
    await query.removeColumn('facilities', 'catchment_id');
}

//# sourceMappingURL=1710374155691-addCatchmentIdToFacility.js.map