"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "syncLastCompleted", {
    enumerable: true,
    get: function() {
        return syncLastCompleted;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _sequelize = require("sequelize");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const syncLastCompleted = (0, _expressasynchandler.default)(async (req, res)=>{
    req.flagPermissionChecked();
    const { store } = req;
    const { models: { SyncSession } } = store;
    const [lastCompleteds] = await store.sequelize.query(`
    SELECT
        coalesce(parameters->>'facilityIds', debug_info->>'facilityIds', debug_info->>'facilityId') AS facilities,
        max(completed_at) AS timestamp
    FROM sync_sessions
    WHERE true
        AND completed_at IS NOT NULL
        AND coalesce(parameters->>'facilityIds', debug_info->>'facilityIds', debug_info->>'facilityId') IS NOT NULL
    GROUP BY facilities
  `);
    const sessions = await Promise.all(lastCompleteds.map(async ({ facilities, timestamp })=>{
        return SyncSession.findOne({
            where: {
                completedAt: timestamp,
                [_sequelize.Op.or]: [
                    {
                        'debugInfo.facilityId': facilities
                    },
                    {
                        'debugInfo.facilityIds': facilities
                    },
                    {
                        'parameters.facilityIds': facilities
                    }
                ]
            }
        });
    }));
    res.send({
        data: sessions.map((session)=>({
                facilityIds: session.parameters.facilityIds || session.debugInfo.facilityIds || [
                    session.debugInfo.facilityId
                ],
                completedAt: session.completedAt,
                duration: session.completedAt - session.createdAt
            })),
        count: lastCompleteds.length
    });
});

//# sourceMappingURL=sync.js.map