"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "addPaginationToWhere", {
    enumerable: true,
    get: function() {
        return addPaginationToWhere;
    }
});
const _sequelize = require("sequelize");
function addPaginationToWhere(where, after) {
    if (!after) {
        return where;
    }
    // once we add more than a single order this will be more complicated
    return {
        [_sequelize.Op.and]: [
            where,
            {
                [_sequelize.Op.or]: [
                    {
                        createdAt: {
                            [_sequelize.Op.lt]: after.createdAt.toISOString()
                        }
                    },
                    {
                        createdAt: {
                            [_sequelize.Op.eq]: after.createdAt.toISOString()
                        },
                        id: {
                            [_sequelize.Op.lt]: after.id
                        }
                    }
                ]
            }
        ]
    };
}

//# sourceMappingURL=addPaginationToWhere.js.map