"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createDbReport: function() {
        return createDbReport;
    },
    updateDbReport: function() {
        return updateDbReport;
    }
});
const _constants = require("@tamanu/constants");
const _utilities = require("@tamanu/database/demoData/utilities");
const _index = require("../../fake/index.js");
const createDbReport = async ({ models: { ReportDefinition, ReportDefinitionVersion }, userId })=>{
    const reportDefinition = await ReportDefinition.create((0, _index.fake)(ReportDefinition, {
        dbSchema: _constants.REPORT_DB_SCHEMAS.REPORTING
    }));
    await ReportDefinitionVersion.create((0, _index.fake)(ReportDefinitionVersion, {
        status: _constants.REPORT_STATUSES.DRAFT,
        queryOptions: `{"parameters": [], "defaultDateRange": "allTime"}`,
        reportDefinitionId: reportDefinition.id,
        userId
    }));
};
const updateDbReport = async ({ models, userId, reportDefinitionId })=>{
    const { ReportDefinitionVersion } = models;
    await ReportDefinitionVersion.create((0, _index.fake)(ReportDefinitionVersion, {
        status: _constants.REPORT_STATUSES.DRAFT,
        queryOptions: `{"parameters": [], "defaultDateRange": "allTime"}`,
        reportDefinitionId: reportDefinitionId || await (0, _utilities.randomRecordId)(models, 'ReportDefinition'),
        userId
    }));
};

//# sourceMappingURL=dbReport.js.map