"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "fromUpstream", {
    enumerable: true,
    get: function() {
        return fromUpstream;
    }
});
const _constants = require("@tamanu/constants");
const _resources = require("@tamanu/shared/utils/fhir/resources");
async function fromUpstream({ payload: { resource, upstreamId } }, { log, models }) {
    const materialisableResources = (0, _resources.resourcesThatCanDo)(models, _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE);
    log.debug('Finding resource by name', {
        resource
    });
    const Resource = materialisableResources.find(({ fhirName })=>fhirName === resource);
    if (!Resource) {
        throw new Error(`FhirRefreshFromUpstream: No materialisable resource found for ${resource}`);
    }
    log.debug('Starting materialise', {
        resource,
        upstreamId
    });
    const result = await Resource.materialiseFromUpstream(upstreamId);
    log.debug('Done materialising', {
        resource,
        upstreamId,
        resourceId: result.id,
        versionId: result.versionId
    });
    const { FhirJob } = models;
    await FhirJob.submit(_constants.JOB_TOPICS.FHIR.RESOLVER, {}, {
        discriminant: 'one at a time'
    });
}

//# sourceMappingURL=fromUpstream.js.map