function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
import { DataTypes } from 'sequelize';
import { PATIENT_ISSUE_TYPES, SYNC_DIRECTIONS } from '@tamanu/constants';
import { getCurrentDateTimeString } from '@tamanu/utils/dateTime';
import { Model } from './Model';
import { buildPatientSyncFilterViaPatientId } from '../sync/buildPatientSyncFilterViaPatientId';
import { buildPatientLinkedLookupFilter } from '../sync/buildPatientLinkedLookupFilter';
import { dateTimeType } from '../types/model';
const PATIENT_ISSUE_TYPE_VALUES = Object.values(PATIENT_ISSUE_TYPES);
export class PatientIssue extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            note: DataTypes.STRING,
            recordedDate: dateTimeType('recordedDate', {
                defaultValue: getCurrentDateTimeString,
                allowNull: false
            }),
            type: {
                type: DataTypes.ENUM(...PATIENT_ISSUE_TYPE_VALUES),
                defaultValue: PATIENT_ISSUE_TYPES.ISSUE,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId'
        });
    }
    static async buildSyncLookupQueryDetails() {
        return buildPatientLinkedLookupFilter(this);
    }
}
_define_property(PatientIssue, "buildPatientSyncFilter", buildPatientSyncFilterViaPatientId);

//# sourceMappingURL=PatientIssue.js.map