"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Table", {
    enumerable: true,
    get: function() {
        return Table;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _Text = require("../pdf/Text");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const basicBorder = '1 solid black';
const tableStyles = _renderer.StyleSheet.create({
    tr: {
        flexDirection: 'row',
        flexWrap: 'wrap',
        borderBottom: basicBorder,
        borderTop: basicBorder,
        marginBottom: -1
    },
    th: {
        flex: 1,
        fontSize: 10,
        fontWeight: 700,
        padding: 3,
        borderRight: basicBorder,
        margin: 0
    },
    td: {
        flex: 1,
        padding: 3,
        fontSize: 10,
        margin: 0,
        borderRight: basicBorder
    }
});
const TR = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        ...props,
        style: tableStyles.tr
    });
const TH = ({ customStyles, ...props })=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        bold: true,
        ...props,
        style: [
            tableStyles.th,
            customStyles
        ]
    });
const TD = ({ customStyles, ...props })=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        wrap: false,
        ...props,
        style: [
            tableStyles.td,
            customStyles
        ]
    });
const Table = ({ data, columns, getLocalisation, getSetting, columnStyle })=>{
    const leftColumnStyle = {
        ...columnStyle,
        borderLeft: basicBorder
    };
    const visibleColumns = columns.filter(({ key })=>getSetting(`fields.${key}.hidden`) !== true);
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: tableStyles.table
    }, /*#__PURE__*/ _react.default.createElement(TR, {
        fixed: true
    }, visibleColumns.map(({ title, key, customStyles }, columnIndex)=>/*#__PURE__*/ _react.default.createElement(TH, {
            key: key,
            customStyles: [
                customStyles,
                columnIndex === 0 ? leftColumnStyle : columnStyle
            ]
        }, title))), data.map((row, rowIndex)=>// eslint-disable-next-line react/no-array-index-key
        /*#__PURE__*/ _react.default.createElement(TR, {
            key: rowIndex
        }, visibleColumns.map(({ accessor, key, customStyles }, columnIndex)=>/*#__PURE__*/ _react.default.createElement(TD, {
                key: key,
                customStyles: [
                    customStyles,
                    columnIndex === 0 ? leftColumnStyle : columnStyle
                ]
            }, accessor ? accessor(row, getLocalisation, getSetting) : row[key])))));
};

//# sourceMappingURL=Table.js.map