"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('patient_conditions', 'resolution_date', {
        type: 'date_time_string',
        allowNull: true
    });
    await query.addColumn('patient_conditions', 'resolution_practitioner_id', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true,
        references: {
            model: 'users',
            key: 'id'
        }
    });
    await query.addColumn('patient_conditions', 'resolution_note', {
        type: _sequelize.DataTypes.TEXT,
        allowNull: true
    });
}
async function down(query) {
    await query.removeColumn('patient_conditions', 'resolution_date');
    await query.removeColumn('patient_conditions', 'resolution_practitioner_id');
    await query.removeColumn('patient_conditions', 'resolution_note');
}

//# sourceMappingURL=1676512990454-addResolvedOngoingConditionsColumns.js.map