import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
import { buildEncounterLinkedSyncFilter } from '../sync/buildEncounterLinkedSyncFilter';
import { buildEncounterLinkedLookupJoins, buildEncounterLinkedLookupSelect } from '../sync/buildEncounterLinkedLookupFilter';
export class InvoicePatientPayment extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            methodId: {
                type: DataTypes.STRING,
                allowNull: false
            },
            chequeNumber: {
                type: DataTypes.STRING,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.InvoicePayment, {
            foreignKey: 'invoicePaymentId',
            as: 'detail'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'methodId',
            as: 'method',
            constraints: false
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return buildEncounterLinkedSyncFilter([
            this.tableName,
            'invoice_payments',
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: buildEncounterLinkedLookupSelect(this),
            joins: buildEncounterLinkedLookupJoins(this, [
                'invoice_payments',
                'invoices',
                'encounters'
            ])
        };
    }
    static getListReferenceAssociations(models) {
        return [
            {
                model: models.ReferenceData,
                as: 'method'
            }
        ];
    }
}

//# sourceMappingURL=InvoicePatientPayment.js.map