import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
export interface Address {
    name?: string;
    address?: string;
    town?: string;
}
export declare class Discharge extends Model {
    id: string;
    note?: string;
    facilityName?: string;
    facilityAddress?: string;
    facilityTown?: string;
    encounterId?: string;
    dischargerId?: string;
    dispositionId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    address(): Promise<Address>;
    static getFullReferenceAssociations(): string[];
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): {
        select: string;
        joins: string;
    };
}
//# sourceMappingURL=Discharge.d.ts.map