"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "notifications", {
    enumerable: true,
    get: function() {
        return notifications;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _errors = require("@tamanu/shared/errors");
const _constants = require("@tamanu/constants");
const _sequelize = require("sequelize");
const _countryDateTime = require("@tamanu/shared/utils/countryDateTime");
const _datefns = require("date-fns");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const notifications = _express.default.Router();
notifications.get('/', (0, _expressasynchandler.default)(async (req, res)=>{
    req.flagPermissionChecked();
    const { models, user, settings, query } = req;
    const facilityId = query.facilityId;
    const recentNotificationsTimeFrame = await settings[facilityId]?.get('notifications.recentNotificationsTimeFrame') || 48;
    const readNotifications = await models.Notification.findAll({
        where: {
            userId: user.id,
            status: _constants.NOTIFICATION_STATUSES.READ,
            createdTime: {
                [_sequelize.Op.gte]: (0, _countryDateTime.toCountryDateTimeString)((0, _datefns.sub)(new Date(), {
                    hours: recentNotificationsTimeFrame
                }))
            }
        },
        include: models.Notification.getFullReferenceAssociations(),
        order: [
            [
                'createdTime',
                'DESC'
            ],
            [
                _sequelize.Sequelize.fn('concat', _sequelize.Sequelize.fn('LOWER', _sequelize.Sequelize.col('patient.first_name')), ' ', _sequelize.Sequelize.fn('LOWER', _sequelize.Sequelize.col('patient.last_name'))),
                'ASC'
            ]
        ]
    });
    const unreadNotifications = await models.Notification.findAll({
        where: {
            userId: user.id,
            status: _constants.NOTIFICATION_STATUSES.UNREAD
        },
        include: models.Notification.getFullReferenceAssociations(),
        order: [
            [
                'createdTime',
                'DESC'
            ],
            [
                _sequelize.Sequelize.fn('concat', _sequelize.Sequelize.fn('LOWER', _sequelize.Sequelize.col('patient.first_name')), ' ', _sequelize.Sequelize.fn('LOWER', _sequelize.Sequelize.col('patient.last_name'))),
                'ASC'
            ]
        ]
    });
    res.json({
        readNotifications,
        unreadNotifications,
        recentNotificationsTimeFrame
    });
}));
notifications.put('/markAsRead/:id', (0, _expressasynchandler.default)(async (req, res)=>{
    req.flagPermissionChecked();
    const { params, models, user } = req;
    const { id } = params;
    const notification = await models.Notification.findOne({
        where: {
            id,
            userId: user.id
        }
    });
    if (!notification) {
        throw new _errors.NotFoundError('Notification not found');
    }
    await notification.update({
        status: _constants.NOTIFICATION_STATUSES.READ
    });
    res.status(204).json();
}));
notifications.put('/markAllAsRead', (0, _expressasynchandler.default)(async (req, res)=>{
    req.flagPermissionChecked();
    const { models, user } = req;
    await models.Notification.update({
        status: _constants.NOTIFICATION_STATUSES.READ
    }, {
        where: {
            userId: user.id,
            status: _constants.NOTIFICATION_STATUSES.UNREAD
        }
    });
    res.status(204).json();
}));

//# sourceMappingURL=notifications.js.map