"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createAccessLog: function() {
        return createAccessLog;
    },
    createPatient: function() {
        return createPatient;
    },
    createPatientCommunication: function() {
        return createPatientCommunication;
    }
});
const _lodash = require("lodash");
const _utilities = require("@tamanu/database/demoData/utilities");
const _index = require("../../fake/index.js");
const createPatient = async ({ models, limit, facilityId, userId, isBirth = _index.chance.bool(), isDead = _index.chance.bool(), allergyCount = _index.chance.integer({
    min: 0,
    max: 5
}) })=>{
    const { Patient, PatientBirthData, PatientAllergy, PatientAdditionalData, PatientDeathData } = models;
    const patient = await Patient.create((0, _index.fake)(Patient));
    await PatientAdditionalData.create((0, _index.fake)(PatientAdditionalData, {
        patientId: patient.id
    }));
    if (isBirth) {
        await PatientBirthData.create((0, _index.fake)(PatientBirthData, {
            patientId: patient.id,
            facilityId: facilityId || await (0, _utilities.randomRecordId)(models, 'Facility')
        }));
    }
    if (isDead) {
        await PatientDeathData.create((0, _index.fake)(PatientDeathData, {
            patientId: patient.id,
            clinicianId: userId || await (0, _utilities.randomRecordId)(models, 'User')
        }));
    }
    await Promise.all((0, _lodash.times)(allergyCount, ()=>limit(async ()=>{
            await PatientAllergy.create((0, _index.fake)(PatientAllergy, {
                patientId: patient.id
            }));
        })));
    return {
        patient
    };
};
const createPatientCommunication = async ({ models: { PatientCommunication }, patientId })=>{
    await PatientCommunication.create((0, _index.fake)(PatientCommunication, {
        patientId
    }));
};
const createAccessLog = async ({ models, patientId, userId, facilityId })=>{
    const { AccessLog } = models;
    await AccessLog.create((0, _index.fake)(AccessLog, {
        recordId: patientId,
        userId: userId || await (0, _utilities.randomRecordId)(models, 'User'),
        facilityId: facilityId || await (0, _utilities.randomRecordId)(models, 'Facility'),
        recordType: 'Patient',
        frontEndContext: {
            patientId
        },
        backEndContext: {
            endPoint: '/patient/:id'
        }
    }));
};

//# sourceMappingURL=patient.js.map