"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _database = require("@tamanu/constants/database");
async function up(query) {
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION get_session_config(key TEXT, default_value TEXT)
    RETURNS text AS $$
    DECLARE
      full_key TEXT = '${_database.SESSION_CONFIG_PREFIX}' || key;
    BEGIN
      RETURN coalesce(nullif(current_setting(full_key, true), ''), default_value);
    END;
    $$ LANGUAGE plpgsql;
  `);
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION set_session_config(key TEXT, value TEXT, is_local BOOLEAN DEFAULT FALSE)
    RETURNS void AS $$
    DECLARE
      full_key TEXT = '${_database.SESSION_CONFIG_PREFIX}' || key;
    BEGIN
      PERFORM set_config(full_key, value, is_local);
    END;
    $$ LANGUAGE plpgsql;
  `);
}
async function down(query) {
    await query.sequelize.query('DROP FUNCTION get_session_config');
    await query.sequelize.query('DROP FUNCTION set_session_config');
}

//# sourceMappingURL=1739969510355-sessionConfigFunctions.js.map