import { Model } from './Model';
import type { InitOptions, ModelProperties, Models } from '../types/model';
import type { Subject } from '@casl/ability';
import type { Facility } from './Facility';
export declare class User extends Model {
    id: string;
    displayId?: string;
    email: string;
    password?: string;
    displayName: string;
    role: string;
    phoneNumber?: string;
    visibilityStatus: string;
    facilities: Facility[];
    static SALT_ROUNDS: number;
    static hashPassword(pw: string): Promise<string>;
    static getSystemUser(): Promise<User | null>;
    forResponse(): any;
    setPassword(pw: string): Promise<void>;
    static sanitizeForInsert(values: any): Promise<any>;
    static update(values: any, options: any): Promise<any>;
    static create(values: any, ...args: any[]): Promise<any>;
    static bulkCreate(records: any[], ...args: any[]): Promise<any>;
    static upsert(values: any, ...args: any[]): Promise<any>;
    static getForAuthByEmail(email: string): Promise<User | null>;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildSyncFilter(): null;
    static getFullReferenceAssociations(): ({
        model: typeof import("./UserDesignation").UserDesignation;
        as: string;
        include: {
            model: typeof import("./ReferenceData").ReferenceData;
            as: string;
        };
        attributes?: undefined;
    } | {
        model: typeof Facility;
        as: string;
        attributes: string[];
        include?: undefined;
    })[];
    static buildSyncLookupQueryDetails(): Promise<null>;
    isSuperUser(): boolean;
    checkPermission(action: string, subject: Subject, field?: string): Promise<void>;
    hasPermission(action: string, subject: Subject, field?: string): Promise<boolean>;
    canSync(facilityIds: string[], { settings }: {
        settings: any;
    }): Promise<boolean>;
    allowedFacilities(): Promise<"ALL" | {
        id: string;
        name: string;
    }[]>;
    allowedFacilityIds(): Promise<string[] | "ALL">;
    canAccessFacility(id: string): Promise<boolean>;
    static filterAllowedFacilities(allowedFacilities: string | ModelProperties<Facility>[], facilityIds: string[]): Promise<{
        id: string;
        name: string;
    }[]>;
}
//# sourceMappingURL=User.d.ts.map