"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "DrugExporter", {
    enumerable: true,
    get: function() {
        return DrugExporter;
    }
});
const _constants = require("@tamanu/constants");
const _ReferenceDataExporter = require("./ReferenceDataExporter");
let DrugExporter = class DrugExporter extends _ReferenceDataExporter.ReferenceDataExporter {
    async getData() {
        const drugs = await this.models.ReferenceData.findAll({
            where: {
                type: _constants.REFERENCE_TYPES.DRUG
            },
            include: {
                model: this.models.ReferenceDrug,
                as: 'referenceDrug'
            }
        });
        return drugs.map((drug)=>({
                ...drug.dataValues,
                route: drug.referenceDrug?.route,
                units: drug.referenceDrug?.units,
                notes: drug.referenceDrug?.notes,
                isSensitive: drug.referenceDrug?.isSensitive
            }));
    }
    customHiddenColumns() {
        return [
            'type',
            'referenceDrug'
        ];
    }
};

//# sourceMappingURL=DrugExporter.js.map