"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "SignerRenewalSender", {
    enumerable: true,
    get: function() {
        return SignerRenewalSender;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _datefns = require("date-fns");
const _sequelize = require("sequelize");
const _tasks = require("@tamanu/shared/tasks");
const _logging = require("@tamanu/shared/services/logging");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let SignerRenewalSender = class SignerRenewalSender extends _tasks.ScheduledTask {
    getName() {
        return 'SignerRenewalSender';
    }
    async run() {
        const { emailService, settings } = this.context;
        const { Signer } = this.context.store.models;
        const pending = await Signer.findAll({
            where: {
                requestSentAt: {
                    [_sequelize.Op.is]: null
                },
                certificate: {
                    [_sequelize.Op.is]: null
                },
                privateKey: {
                    [_sequelize.Op.not]: null
                }
            },
            // hard limit: there really should only ever be zero or one
            // pending signers at any given time, but just in case:
            limit: 5
        });
        if (pending.length === 0) return; // nothing to do
        if (pending.length > 1) {
            _logging.log.warn(`There is more than one pending signer CSR, sending all of them, but this may be a bug: ${pending.map((s)=>s.id).join(', ')}`);
        }
        const { subject, body: text } = await settings.get('templates.signerRenewalEmail');
        _logging.log.info(`Emailing ${pending.length} CSR(s) to ${_config.default.integrations.signer.sendSignerRequestTo}`);
        for (const signer of pending){
            try {
                await emailService.sendEmail({
                    to: _config.default.integrations.signer.sendSignerRequestTo,
                    from: _config.default.mailgun.from,
                    subject,
                    text,
                    attachment: {
                        filename: `Tamanu_${(0, _datefns.format)(signer.createdAt, 'yyyy-MM-dd')}.csr`,
                        data: Buffer.from(signer.request)
                    }
                });
                await signer.update({
                    requestSentAt: _sequelize.Sequelize.literal('CURRENT_TIMESTAMP')
                });
            } catch (e) {
                _logging.log.error(`Failed to send CSR email: ${e}, will retry in 24h`);
            }
        }
    }
    constructor(context){
        const conf = _config.default.schedules.signerRenewalSender;
        const { schedule, jitterTime, enabled } = conf;
        super(schedule, _logging.log, jitterTime, enabled);
        this.config = conf;
        this.context = context;
    }
};

//# sourceMappingURL=SignerRenewalSender.js.map