"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Survey", {
    enumerable: true,
    get: function() {
        return Survey;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let Survey = class Survey extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            code: _sequelize.DataTypes.STRING,
            name: _sequelize.DataTypes.STRING,
            surveyType: {
                type: _sequelize.DataTypes.STRING,
                defaultValue: _constants.SURVEY_TYPES.PROGRAMS
            },
            isSensitive: {
                type: _sequelize.DataTypes.BOOLEAN,
                defaultValue: false,
                allowNull: false
            },
            visibilityStatus: {
                type: _sequelize.DataTypes.STRING,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT,
                allowNull: false
            },
            notifiable: {
                type: _sequelize.DataTypes.BOOLEAN,
                defaultValue: false,
                allowNull: false
            },
            notifyEmailAddresses: {
                type: _sequelize.DataTypes.ARRAY(_sequelize.DataTypes.STRING),
                allowNull: false,
                defaultValue: []
            }
        }, {
            ...options,
            indexes: [
                {
                    unique: true,
                    fields: [
                        'code'
                    ]
                }
            ],
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Program, {
            foreignKey: 'programId',
            as: 'program'
        });
        this.hasMany(models.SurveyScreenComponent, {
            as: 'components',
            foreignKey: 'surveyId'
        });
    }
    static getAllReferrals() {
        return this.findAll({
            where: {
                surveyType: _constants.SURVEY_TYPES.REFERRAL
            }
        });
    }
    static getVitalsSurvey() {
        return this.findOne({
            where: {
                surveyType: _constants.SURVEY_TYPES.VITALS
            }
        });
    }
    static async getResponsePermissionCheck(id) {
        const survey = await this.findByPk(id);
        if (!survey || survey.visibilityStatus !== _constants.VISIBILITY_STATUSES.CURRENT) {
            throw new Error('Survey not found');
        }
        if (survey.surveyType === _constants.SURVEY_TYPES.VITALS) {
            return 'Vitals';
        }
        if (_constants.CHARTING_SURVEY_TYPES.includes(survey.surveyType)) {
            return 'Charting';
        }
        return 'SurveyResponse';
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=Survey.js.map