"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "noteChangelogsHandler", {
    enumerable: true,
    get: function() {
        return noteChangelogsHandler;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _checkNotePermission = require("../../utils/checkNotePermission");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const noteChangelogsHandler = (recordType)=>(0, _expressasynchandler.default)(async (req, res)=>{
        const { models, params } = req;
        const { id: recordId, noteId: rootNoteId } = params;
        await (0, _checkNotePermission.checkNotePermission)(req, {
            recordType,
            recordId
        }, 'list');
        const notes = await models.Note.findAll({
            include: [
                {
                    model: models.User,
                    as: 'author'
                },
                {
                    model: models.User,
                    as: 'onBehalfOf'
                }
            ],
            where: {
                [_sequelize.Op.or]: [
                    {
                        revisedById: rootNoteId
                    },
                    {
                        id: rootNoteId
                    }
                ],
                visibilityStatus: _constants.VISIBILITY_STATUSES.CURRENT
            },
            order: [
                [
                    'date',
                    'DESC'
                ]
            ]
        });
        res.send({
            data: notes,
            count: notes.length
        });
    });

//# sourceMappingURL=noteChangelogsHandler.js.map