"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getSortParameterName: function() {
        return getSortParameterName;
    },
    hl7SortToTamanu: function() {
        return hl7SortToTamanu;
    }
});
const _errors = require("@tamanu/shared/errors");
const _hl7PatientFields = require("../hl7PatientFields");
function getSortParameterName(sort) {
    return sort[0] === '-' ? sort.slice(1) : sort;
}
function hl7SortToTamanu(hl7Sort, modelName) {
    // Sorts are a comma separated list of parameters
    const sorts = hl7Sort.split(',');
    // Create list of Tamanu sorts
    const tamanuSorts = sorts.map((sort)=>{
        // Allow a "-" at the beginning to reverse sort
        const parameter = getSortParameterName(sort);
        const direction = sort[0] === '-' ? 'DESC' : 'ASC';
        // Base parameters
        if (parameter === 'issued') return [
            'createdAt',
            direction
        ];
        // Parse patient parameters
        if (modelName === 'Patient') {
            if (_hl7PatientFields.sortableHL7PatientFields.includes(parameter)) {
                const { fieldName, sortArguments } = _hl7PatientFields.hl7PatientFields[parameter];
                const args = sortArguments || [
                    fieldName
                ];
                return [
                    ...args,
                    direction
                ];
            }
        }
        // Something went terribly wrong
        throw new _errors.InvalidParameterError(`Unrecognised sort parameter in: ${hl7Sort}`);
    });
    // Always sort by descending ID last
    tamanuSorts.push([
        'id',
        'DESC'
    ]);
    return tamanuSorts;
}

//# sourceMappingURL=sort.js.map