"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.sequelize.query(`
      UPDATE permissions
      SET id = REPLACE(id, 'encountermedication', 'medication')
      WHERE id LIKE '%encountermedication%'
      AND noun = 'Medication';
    `);
}
async function down() {
// It's not possible to reverse the migration to its original state,
//
// An edge case:
// practitioner.medication.read.any (noun = 'Medication')
// admin.encountermedication.write.any (noun = 'Medication')
//
// After up:
// practitioner.medication.read.any (unchanged - doesn't contain 'encountermedication')
// admin.medication.write.any (changed from 'encountermedication' -> 'medication')
//
// After down:
// practitioner.encountermedication.read.any (WRONG! This was never 'encountermedication')
// admin.encountermedication.write.any (correct reversal)
//
// This is an edge case that we can't reverse. So leaving down migration empty.
}

//# sourceMappingURL=1754523298680-updateMedicationPermissionIds.js.map