"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "publicRoutes", {
    enumerable: true,
    get: function() {
        return publicRoutes;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _logging = require("@tamanu/shared/services/logging");
const _lodash = require("lodash");
const _labResultWidget = require("./labResultWidget");
const _integrations = require("../integrations");
const _telegramWebhook = require("./telegramWebhook");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const publicRoutes = _express.default.Router();
const { cors } = _config.default;
if (cors.allowedOrigin) {
    publicRoutes.use((req, res, next)=>{
        res.setHeader('Access-Control-Allow-Origin', cors.allowedOrigin);
        next();
    });
} else {
    _logging.log.warn('publicRoutes: CORS has not been set up for this server; external widgets like the COVID test results will be unavailable until cors.allowedOrigin is set to the appropriate domain');
}
publicRoutes.get('/ping', (_req, res)=>{
    res.send({
        ok: true
    });
});
publicRoutes.get('/translation/languageOptions', async (req, res)=>{
    const { TranslatedString } = req.models;
    const response = await TranslatedString.getPossibleLanguages();
    res.send(response);
});
publicRoutes.get('/translation/:language', async (req, res)=>{
    const { models: { TranslatedString }, params: { language } } = req;
    const translatedStringRecords = await TranslatedString.findAll({
        where: {
            language
        },
        attributes: [
            'stringId',
            'text'
        ]
    });
    res.send((0, _lodash.mapValues)((0, _lodash.keyBy)(translatedStringRecords, 'stringId'), 'text'));
});
publicRoutes.use('/labResultWidget', _labResultWidget.labResultWidgetRoutes);
publicRoutes.use('/integration', _integrations.publicIntegrationRoutes);
publicRoutes.use('/telegram-webhook', _telegramWebhook.telegramWebhookRoutes);

//# sourceMappingURL=index.js.map