export declare const PATIENT_REGISTRY_TYPES: {
    NEW_PATIENT: string;
    BIRTH_REGISTRY: string;
};
export declare const BIRTH_DELIVERY_TYPES: {
    NORMAL_VAGINAL_DELIVERY: string;
    BREECH: string;
    EMERGENCY_C_SECTION: string;
    ELECTIVE_C_SECTION: string;
    VACUUM_EXTRACTION: string;
    FORCEPS: string;
    OTHER: string;
};
export declare const BIRTH_TYPES: {
    SINGLE: string;
    PLURAL: string;
};
export declare const PLACE_OF_BIRTH_TYPES: {
    HEALTH_FACILITY: string;
    HOME: string;
    OTHER: string;
};
export declare const ATTENDANT_OF_BIRTH_TYPES: {
    DOCTOR: string;
    MIDWIFE: string;
    NURSE: string;
    TRADITIONAL_BIRTH_ATTENDANT: string;
    OTHER: string;
};
export declare const ATTENDANT_OF_BIRTH_LABELS: {
    [ATTENDANT_OF_BIRTH_TYPES.DOCTOR]: string;
    [ATTENDANT_OF_BIRTH_TYPES.MIDWIFE]: string;
    [ATTENDANT_OF_BIRTH_TYPES.NURSE]: string;
    [ATTENDANT_OF_BIRTH_TYPES.TRADITIONAL_BIRTH_ATTENDANT]: string;
    [ATTENDANT_OF_BIRTH_TYPES.OTHER]: string;
};
export declare const ATTENDANT_OF_BIRTH_OPTIONS: {
    value: string;
    label: string | undefined;
}[];
export declare const BIRTH_DELIVERY_TYPE_LABELS: {
    [BIRTH_DELIVERY_TYPES.NORMAL_VAGINAL_DELIVERY]: string;
    [BIRTH_DELIVERY_TYPES.BREECH]: string;
    [BIRTH_DELIVERY_TYPES.EMERGENCY_C_SECTION]: string;
    [BIRTH_DELIVERY_TYPES.ELECTIVE_C_SECTION]: string;
    [BIRTH_DELIVERY_TYPES.VACUUM_EXTRACTION]: string;
    [BIRTH_DELIVERY_TYPES.FORCEPS]: string;
    [BIRTH_DELIVERY_TYPES.OTHER]: string;
};
export declare const BIRTH_DELIVERY_TYPE_OPTIONS: {
    value: string;
    label: string | undefined;
}[];
export declare const BIRTH_TYPE_LABELS: {
    [BIRTH_TYPES.SINGLE]: string;
    [BIRTH_TYPES.PLURAL]: string;
};
export declare const BIRTH_TYPE_OPTIONS: {
    value: string;
    label: string | undefined;
}[];
export declare const PLACE_OF_BIRTH_LABELS: {
    [PLACE_OF_BIRTH_TYPES.HEALTH_FACILITY]: string;
    [PLACE_OF_BIRTH_TYPES.HOME]: string;
    [PLACE_OF_BIRTH_TYPES.OTHER]: string;
};
export declare const PLACE_OF_BIRTH_OPTIONS: {
    value: string;
    label: string | undefined;
}[];
//# sourceMappingURL=births.d.ts.map