"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PharmacyOrder", {
    enumerable: true,
    get: function() {
        return PharmacyOrder;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _sync = require("../sync");
let PharmacyOrder = class PharmacyOrder extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            comments: _sequelize.DataTypes.TEXT,
            isDischargePrescription: _sequelize.DataTypes.BOOLEAN
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'orderingClinicianId',
            as: 'orderingClinician'
        });
        this.belongsTo(models.Encounter, {
            foreignKey: 'encounterId',
            as: 'encounter'
        });
        this.hasMany(models.PharmacyOrderPrescription, {
            foreignKey: 'pharmacyOrderId',
            as: 'pharmacyOrderPrescriptions'
        });
    }
    static getListReferenceAssociations() {
        return [
            'orderingClinician',
            'encounter'
        ];
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _sync.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return (0, _sync.buildEncounterLinkedLookupFilter)(this);
    }
};

//# sourceMappingURL=PharmacyOrder.js.map