"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Procedure", {
    enumerable: true,
    get: function() {
        return Procedure;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildEncounterLinkedSyncFilter = require("../sync/buildEncounterLinkedSyncFilter");
const _buildEncounterLinkedLookupFilter = require("../sync/buildEncounterLinkedLookupFilter");
const _model = require("../types/model");
let Procedure = class Procedure extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            completed: {
                type: _sequelize.DataTypes.BOOLEAN,
                defaultValue: false
            },
            date: (0, _model.dateTimeType)('date', {
                allowNull: false
            }),
            endTime: (0, _model.dateTimeType)('endTime'),
            startTime: (0, _model.dateTimeType)('startTime'),
            note: _sequelize.DataTypes.TEXT,
            completedNote: _sequelize.DataTypes.TEXT,
            timeIn: (0, _model.dateTimeType)('timeIn'),
            timeOut: (0, _model.dateTimeType)('timeOut')
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static getListReferenceAssociations() {
        return [
            'Location',
            'ProcedureType',
            'Anaesthetic',
            'Department',
            'AssistantClinicians',
            'SurveyResponses'
        ];
    }
    static initRelations(models) {
        this.belongsTo(models.Encounter, {
            foreignKey: 'encounterId',
            as: 'encounter'
        });
        this.belongsTo(models.Location, {
            foreignKey: 'locationId',
            as: 'Location'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'procedureTypeId',
            as: 'ProcedureType'
        });
        this.belongsTo(models.User, {
            foreignKey: 'physicianId',
            as: 'LeadClinician'
        });
        this.belongsTo(models.User, {
            foreignKey: 'anaesthetistId',
            as: 'Anaesthetist'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'anaestheticId',
            as: 'Anaesthetic'
        });
        this.belongsTo(models.Department, {
            foreignKey: 'departmentId',
            as: 'Department'
        });
        this.belongsTo(models.User, {
            foreignKey: 'assistantAnaesthetistId',
            as: 'AssistantAnaesthetist'
        });
        this.belongsToMany(models.User, {
            through: 'ProcedureAssistantClinician',
            as: 'AssistantClinicians',
            foreignKey: 'procedureId'
        });
        this.belongsToMany(models.SurveyResponse, {
            through: 'ProcedureSurveyResponse',
            as: 'SurveyResponses',
            foreignKey: 'procedureId'
        });
    }
    forResponse() {
        const procedureResponse = super.forResponse();
        const assistantClinicians = this.dataValues?.AssistantClinicians;
        if (!assistantClinicians) {
            return procedureResponse;
        }
        // Parse the nested many to many data for assistantClinicians
        const assistantCliniciansData = assistantClinicians.map((assistantClinician)=>assistantClinician.forResponse());
        return {
            ...procedureResponse,
            assistantClinicians: assistantCliniciansData
        };
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupFilter)(this);
    }
};

//# sourceMappingURL=Procedure.js.map