import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
import { buildEncounterLinkedSyncFilter } from '../sync/buildEncounterLinkedSyncFilter';
import { dateTimeType } from '../types/model';
import { buildEncounterLinkedLookupJoins, buildEncounterLinkedLookupSelect } from '../sync/buildEncounterLinkedLookupFilter';
export class InvoiceDiscount extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            percentage: {
                type: DataTypes.DECIMAL,
                allowNull: false
            },
            reason: DataTypes.STRING,
            isManual: {
                type: DataTypes.BOOLEAN,
                allowNull: false
            },
            appliedTime: dateTimeType('appliedTime', {
                allowNull: false
            })
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Invoice, {
            foreignKey: 'invoiceId',
            as: 'invoice'
        });
        this.belongsTo(models.User, {
            foreignKey: 'appliedByUserId',
            as: 'appliedByUser'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return buildEncounterLinkedSyncFilter([
            this.tableName,
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: buildEncounterLinkedLookupSelect(this),
            joins: buildEncounterLinkedLookupJoins(this, [
                'invoices',
                'encounters'
            ])
        };
    }
}

//# sourceMappingURL=InvoiceDiscount.js.map