import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
export declare class PatientProgramRegistration extends Model {
    id: string;
    date: string;
    registrationStatus: string;
    patientId: string;
    programRegistryId: string;
    clinicalStatusId?: string;
    clinicianId?: string;
    registeringFacilityId?: string;
    facilityId?: string;
    villageId?: string;
    deactivatedClinicianId?: string;
    deactivatedDate?: string;
    static initModel(options: InitOptions): void;
    static getFullReferenceAssociations(): string[];
    static getListReferenceAssociations(): string[];
    static initRelations(models: Models): void;
    static getRegistrationsForPatient(patientId: string): Promise<PatientProgramRegistration[]>;
    static buildSyncFilter(): null;
    static buildSyncLookupQueryDetails(): null;
}
//# sourceMappingURL=PatientProgramRegistration.d.ts.map