import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
import { buildEncounterLinkedLookupJoins, buildEncounterLinkedLookupSelect, buildEncounterLinkedSyncFilter } from '../sync';
export class ProcedureSurveyResponse extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            procedureId: {
                type: DataTypes.STRING,
                allowNull: false,
                field: 'procedure_id'
            },
            surveyResponseId: {
                type: DataTypes.STRING,
                allowNull: false,
                field: 'survey_response_id'
            }
        }, {
            ...options,
            tableName: 'procedure_survey_responses',
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Procedure, {
            foreignKey: 'procedureId',
            as: 'procedure'
        });
        this.belongsTo(models.SurveyResponse, {
            foreignKey: 'surveyResponseId',
            as: 'surveyResponse'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return buildEncounterLinkedSyncFilter([
            this.tableName,
            'procedures',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: buildEncounterLinkedLookupSelect(this),
            joins: buildEncounterLinkedLookupJoins(this, [
                'procedures',
                'encounters'
            ])
        };
    }
}

//# sourceMappingURL=ProcedureSurveyResponse.js.map