import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
import { DataTypes, Sequelize } from 'sequelize';
export class ProcedureTypeSurvey extends Model {
    static initModel(options) {
        super.init({
            id: {
                type: DataTypes.UUID,
                allowNull: false,
                primaryKey: true,
                defaultValue: Sequelize.fn('gen_random_uuid')
            },
            procedureTypeId: {
                type: DataTypes.STRING,
                allowNull: false
            },
            surveyId: {
                type: DataTypes.STRING,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
            uniqueKeys: {
                procedure_type_survey_unique: {
                    fields: [
                        'procedure_type_id',
                        'survey_id'
                    ]
                }
            }
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'procedureTypeId',
            as: 'procedureType'
        });
        this.belongsTo(models.Survey, {
            foreignKey: 'surveyId',
            as: 'survey'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
}

//# sourceMappingURL=ProcedureTypeSurvey.js.map