import { Model } from './Model';
import type { InitOptions } from '../types/model';
type TranslationOptions = {
    replacements?: Record<string, string>;
    casing?: 'uppercase' | 'lowercase' | 'sentence';
};
export declare class TranslatedString extends Model {
    id: string;
    stringId: string;
    language: string;
    text: string;
    static initModel(options: InitOptions): void;
    static buildSyncFilter(): null;
    static buildSyncLookupQueryDetails(): null;
    static getPossibleLanguages: () => Promise<{
        languagesInDb: TranslatedString[];
        languageNames: TranslatedString[];
        countryCodes: TranslatedString[];
    }>;
    static getTranslations: (language: string, prefixIds: string[]) => Promise<import("lodash").Dictionary<string>>;
    static getTranslationFunction: (language: string, prefixIds?: string[]) => Promise<(stringId: string, fallback: string, translationOptions?: TranslationOptions) => string>;
    static getEnumTranslationFunction: (language: string, prefixIds?: string[]) => Promise<(enumValues: Record<string, string>, currentValue: string) => string>;
}
export {};
//# sourceMappingURL=TranslatedString.d.ts.map