"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "deleteRedundantLocalCopies", {
    enumerable: true,
    get: function() {
        return deleteRedundantLocalCopies;
    }
});
const _constants = require("@tamanu/constants");
const _sync = require("@tamanu/database/sync");
const _sequelize = require("sequelize");
const deleteRedundantLocalCopies = async (models, changes)=>{
    const modelsForPushThenDelete = (0, _sync.getModelsForDirections)(models, [
        _constants.SYNC_DIRECTIONS.PUSH_TO_CENTRAL_THEN_DELETE
    ]);
    for (const model of Object.values(modelsForPushThenDelete)){
        const changesForModel = changes.filter((change)=>change.recordType === model.tableName);
        const idsToDelete = changesForModel.map((change)=>change.recordId);
        await model.destroy({
            where: {
                id: {
                    [_sequelize.Op.in]: idsToDelete
                }
            },
            force: true
        });
    }
};

//# sourceMappingURL=deleteRedundantLocalCopies.js.map