"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientOngoingPrescription", {
    enumerable: true,
    get: function() {
        return PatientOngoingPrescription;
    }
});
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildPatientSyncFilterViaPatientId = require("../sync/buildPatientSyncFilterViaPatientId");
const _buildEncounterLinkedLookupFilter = require("../sync/buildEncounterLinkedLookupFilter");
const _sequelize = require("sequelize");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let PatientOngoingPrescription = class PatientOngoingPrescription extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        this.belongsTo(models.Prescription, {
            foreignKey: 'prescriptionId',
            as: 'prescription'
        });
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupSelect)(this, {
                patientId: 'COALESCE(encounters.patient_id, patient_ongoing_prescriptions.patient_id)'
            }),
            joins: `
        LEFT JOIN encounter_prescriptions ON patient_ongoing_prescriptions.prescription_id = encounter_prescriptions.prescription_id
        LEFT JOIN encounters ON encounter_prescriptions.encounter_id = encounters.id
        LEFT JOIN locations ON encounters.location_id = locations.id
        LEFT JOIN facilities ON locations.facility_id = facilities.id
      `
        };
    }
    static findPatientOngoingPrescriptionWithSameDetails(patientId, prescription) {
        const { models } = this.sequelize;
        return this.findOne({
            where: {
                patientId: patientId
            },
            include: [
                {
                    model: models.Prescription,
                    as: 'prescription',
                    where: {
                        medicationId: prescription.medicationId,
                        doseAmount: prescription.doseAmount,
                        units: prescription.units,
                        route: prescription.route,
                        frequency: prescription.frequency,
                        discontinued: {
                            [_sequelize.Op.not]: true
                        }
                    }
                }
            ]
        });
    }
};
_define_property(PatientOngoingPrescription, "buildPatientSyncFilter", _buildPatientSyncFilterViaPatientId.buildPatientSyncFilterViaPatientId);

//# sourceMappingURL=PatientOngoingPrescription.js.map