"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ProcedureSurveyResponse", {
    enumerable: true,
    get: function() {
        return ProcedureSurveyResponse;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _sync = require("../sync");
let ProcedureSurveyResponse = class ProcedureSurveyResponse extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            procedureId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                field: 'procedure_id'
            },
            surveyResponseId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                field: 'survey_response_id'
            }
        }, {
            ...options,
            tableName: 'procedure_survey_responses',
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Procedure, {
            foreignKey: 'procedureId',
            as: 'procedure'
        });
        this.belongsTo(models.SurveyResponse, {
            foreignKey: 'surveyResponseId',
            as: 'surveyResponse'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _sync.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'procedures',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: (0, _sync.buildEncounterLinkedLookupSelect)(this),
            joins: (0, _sync.buildEncounterLinkedLookupJoins)(this, [
                'procedures',
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=ProcedureSurveyResponse.js.map