import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
export declare class ReferenceDrug extends Model {
    id: string;
    referenceDataId: string;
    route?: string;
    units?: string;
    notes?: string;
    isSensitive: boolean;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildSyncFilter(): null;
    static buildSyncLookupQueryDetails(): null;
    static getFullReferenceAssociations(): string[];
    /**
     * Check if any medications in the given list are sensitive
     * @param medicationIds - Array of medication IDs to check
     * @returns Promise<boolean> - True if any medication is sensitive, false otherwise
     */
    static hasSensitiveMedication(medicationIds: string[]): Promise<boolean>;
}
//# sourceMappingURL=ReferenceDrug.d.ts.map