import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
export declare class Survey extends Model {
    id: string;
    code?: string;
    name?: string;
    surveyType: string;
    isSensitive: boolean;
    visibilityStatus: string;
    notifiable: boolean;
    notifyEmailAddresses: string[];
    programId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static getAllReferrals(): Promise<Survey[]>;
    static getVitalsSurvey(): Promise<Survey | null>;
    static getResponsePermissionCheck(id: string): Promise<"Vitals" | "Charting" | "SurveyResponse">;
    static buildSyncFilter(): null;
    static buildSyncLookupQueryDetails(): null;
}
//# sourceMappingURL=Survey.d.ts.map