import { type Transaction } from 'sequelize';
import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
import type { Encounter } from './Encounter';
import type { TaskDesignation } from './TaskDesignation';
declare const TASK_STATUS_VALUES: string[];
export declare class Task extends Model {
    id: string;
    name: string;
    dueTime: string;
    endTime?: string;
    requestTime: string;
    status: (typeof TASK_STATUS_VALUES)[number];
    note?: string;
    frequencyValue?: number;
    frequencyUnit?: string;
    durationValue?: number;
    durationUnit?: string;
    highPriority?: boolean;
    parentTaskId?: string;
    completedTime?: string;
    completedNote?: string;
    notCompletedTime?: string;
    todoTime?: string;
    todoNote?: string;
    deletedTime?: string;
    encounterId?: string;
    requestedByUserId?: string;
    completedByUserId?: string;
    notCompletedByUserId?: string;
    todoByUserId?: string;
    deletedByUserId?: string;
    notCompletedReasonId?: string;
    deletedReasonId?: string;
    deletedReasonForSyncId?: string;
    taskType: string;
    designations: TaskDesignation[];
    static initModel({ primaryKey, ...options }: InitOptions, models: Models): void;
    isRepeatingTask(): string | 0 | undefined;
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): {
        select: string;
        joins: string;
    };
    static getFullReferenceAssociations(): ({
        model: typeof Encounter;
        as: string;
        attributes: string[];
        through?: undefined;
    } | {
        model: typeof import("./User").User;
        as: string;
        attributes: string[];
        through?: undefined;
    } | {
        model: typeof import("./ReferenceData").ReferenceData;
        as: string;
        attributes: string[];
        through?: undefined;
    } | {
        model: typeof import("./ReferenceData").ReferenceData;
        as: string;
        attributes: string[];
        through: {
            attributes: never[];
        };
    })[];
    static generateRepeatingTasks(tasks: Task[]): Promise<void>;
    static onEncounterDischarged(encounter: Encounter, transaction?: Transaction): Promise<void>;
}
export {};
//# sourceMappingURL=Task.d.ts.map