/**
 * @param {import('./model.js').Value | import('./model.js').Identifier | import('./model.js').Entry | import('./model.js').Node | import('./model.js').Document} element
 * @returns {Location=}
 */
export function getLocation(element: import('./model.js').Value | import('./model.js').Identifier | import('./model.js').Entry | import('./model.js').Node | import('./model.js').Document): Location | undefined;
/**
 * @param {import('./model.js').Value | import('./model.js').Identifier | import('./model.js').Entry | import('./model.js').Node | import('./model.js').Document} element
 * @param {Location} location
 */
export function storeLocation(element: import('./model.js').Value | import('./model.js').Identifier | import('./model.js').Entry | import('./model.js').Node | import('./model.js').Document, location: Location): void;
/**
 * Location inside source text
 */
export type Location = {
    /**
     * Offset of the first character. 0-indexed.
     */
    startOffset: number;
    /**
     * Line of the first character. 1-indexed.
     */
    startLine?: number | undefined;
    /**
     * Column of the first character of the Token. 1-indexed.
     */
    startColumn?: number | undefined;
    /**
     * Offset behind the last character. 0-indexed.
     */
    endOffset: number;
    /**
     * Line of the last character. 1-indexed.
     */
    endLine?: number | undefined;
    /**
     * Column of the last character of the Token. 1-indexed.
     */
    endColumn?: number | undefined;
};
