"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    importReportCommand: function() {
        return importReportCommand;
    },
    listReportCommand: function() {
        return listReportCommand;
    }
});
const _commander = require("commander");
const _fs = require("fs");
const _database = require("../../database");
const _utils = /*#__PURE__*/ _interop_require_wildcard(require("./utils"));
const _actions = /*#__PURE__*/ _interop_require_wildcard(require("./actions"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
async function importReport(options) {
    const { name, ...versionData } = JSON.parse(await _fs.promises.readFile(options.file));
    const overriddenName = options.name || name;
    if (!overriddenName) {
        throw new Error('Name must be provided in the JSON file or via the -n parameter');
    }
    const store = await (0, _database.initDatabase)({
        testMode: false
    });
    const definition = await _utils.findOrCreateDefinition(overriddenName, store);
    const versions = await definition.getVersions();
    await _actions.createVersion(versionData, definition, versions, store, options.verbose);
    process.exit(0);
}
const importReportCommand = new _commander.Command('importReport').description('Import a JSON report definition version').requiredOption('-f, --file <path>', 'Path to report definition version data JSON').option('-v, --verbose', 'log additional details during import').option('-n, --name <string>', 'override JSON-defined report name').action(importReport);
async function listReport(options) {
    const store = await (0, _database.initDatabase)({
        testMode: false
    });
    const { name } = options;
    const definition = await store.models.ReportDefinition.findOne({
        where: {
            name
        }
    });
    if (!definition) throw new Error(`No definition found with name=${name}`);
    const versions = await definition.getVersions();
    await _actions.listVersions(definition, versions, store);
    process.exit(0);
}
const listReportCommand = new _commander.Command('listReport').description('List the existing versions of a report definition').requiredOption('-n, --name <string>', 'Name of the report').action(listReport);

//# sourceMappingURL=index.js.map